import { Request } from 'express';
import { User } from '@supabase/supabase-js';

// Extend Express Request to include user
export interface AuthenticatedRequest extends Request {
  user?: User;
  vendor?: Vendor;
}

// Vendor interface
export interface Vendor {
  id: string;
  user_id: string;
  email: string;
  business_name: string | null;
  profile_picture_url: string | null;
  onboarding_status: 'incomplete' | 'complete';
  subscription_plan: string;
  created_at: string;
  updated_at: string;
}

// Auth request interfaces
export interface SignupRequest {
  email: string;
  password: string;
  business_name?: string;
}

export interface LoginRequest {
  email: string;
  password: string;
}

export interface OnboardingRequest {
  business_name: string;
  profile_picture_url?: string;
}

// API Response interfaces
export interface ApiResponse<T = any> {
  success: boolean;
  data?: T;
  message?: string;
  error?: string;
}

export interface AuthResponse {
  user: User;
  vendor: Vendor;
  access_token: string;
  refresh_token: string;
}

// Error types
export interface AppError extends Error {
  statusCode?: number;
  isOperational?: boolean;
}

// Database types
export interface DatabaseUser {
  id: string;
  email: string;
  role: string;
  created_at: string;
  updated_at: string;
}

export interface DatabaseVendor {
  id: string;
  user_id: string;
  email: string;
  business_name: string | null;
  profile_picture_url: string | null;
  onboarding_status: 'incomplete' | 'complete';
  subscription_plan: string;
  created_at: string;
  updated_at: string;
} 